import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 9))

# Define colors for each piece and clear status
colors = {
    'rightl0': 'blue',
    'rightl1': 'green',
    'square0': 'red',
    'square1': 'yellow',
    'clear': 'lightgreen'
}

# Draw the grid and initial state
for row in range(6):
    for col in range(4):
        # Determine if the position is clear or occupied
        if (row == 5) or (row == 4) or (row == 3 and col in [2, 3]) or (row == 2 and col in [1, 3]) or (row == 1 and col == 3) or (row == 0 and col in [1, 2, 3]):
            facecolor = colors['clear']
            text = f'f{5-row}-{col}f\nClear'
        else:
            facecolor = 'none'
            text = ''

        rect = patches.Rectangle((col, 5-row), 1, 1, linewidth=1, edgecolor='gray', facecolor=facecolor)
        ax.add_patch(rect)
        if text:
            ax.text(col+0.5, 5-row+0.5, text, ha='center', va='center', fontsize=8, color='black')

# Draw pieces with bold outer edges
# Right-L piece "rightl0" (blue)
rightl0_positions = [(0, 3), (1, 3), (0, 2)]
for pos in rightl0_positions:
    rect = patches.Rectangle(pos, 1, 1, linewidth=3, edgecolor='black', facecolor=colors['rightl0'])
    ax.add_patch(rect)
    ax.text(pos[0]+0.5, pos[1]+0.5, 'rightl0', ha='center', va='center', fontsize=8, color='white')

# Right-L piece "rightl1" (green)
rightl1_positions = [(0, 1), (1, 1), (0, 0)]
for pos in rightl1_positions:
    rect = patches.Rectangle(pos, 1, 1, linewidth=3, edgecolor='black', facecolor=colors['rightl1'])
    ax.add_patch(rect)
    ax.text(pos[0]+0.5, pos[1]+0.5, 'rightl1', ha='center', va='center', fontsize=8, color='white')

# Single-square piece "square0" (red)
square0_position = (2, 1)
rect = patches.Rectangle(square0_position, 1, 1, linewidth=3, edgecolor='black', facecolor=colors['square0'])
ax.add_patch(rect)
ax.text(square0_position[0]+0.5, square0_position[1]+0.5, 'square0', ha='center', va='center', fontsize=8, color='white')

# Single-square piece "square1" (yellow)
square1_position = (2, 2)
rect = patches.Rectangle(square1_position, 1, 1, linewidth=3, edgecolor='black', facecolor=colors['square1'])
ax.add_patch(rect)
ax.text(square1_position[0]+0.5, square1_position[1]+0.5, 'square1', ha='center', va='center', fontsize=8, color='black')

# Set limits and hide axes
ax.set_xlim(0, 4)
ax.set_ylim(0, 6)
ax.set_xticks([])
ax.set_yticks([])
ax.set_aspect('equal')

# Add legend
legend_patches = [
    patches.Patch(color=colors['rightl0'], label='Right-L Piece (rightl0)'),
    patches.Patch(color=colors['rightl1'], label='Right-L Piece (rightl1)'),
    patches.Patch(color=colors['square0'], label='Single-Square Piece (square0)'),
    patches.Patch(color=colors['square1'], label='Single-Square Piece (square1)'),
    patches.Patch(color=colors['clear'], label='Clear Position')
]
ax.legend(handles=legend_patches, loc='upper right', fontsize=8)

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_50.png', bbox_inches='tight')
plt.show()